#include <algorithm>
#include <iostream>
#include <numeric>
#include <vector>
#include <string>
#include <map>
#include <set>
using namespace std;
typedef long long ll;

vector<int> bruteforce(const vector<int>& xor_values)
{
	int n = xor_values.size();
	
	vector<int> cnt;
	for (int d = 1; d <= n; d++)
	{
		int cnt_correct = 0;
		if (n%d == 0)
		{
			for (int i = 0; i < n; i++)
			{
				if (xor_values[i] == xor_values[(i+d)%n])
				{
					cnt_correct++;
				}
			}
			cnt.push_back(cnt_correct);
		}
	}
	return cnt;
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	srand(27283234);

	int n; cin >> n;
	vector<int> possible_periods;
	for (int i = 1; i <= n; i++)
	{
		if (n % i == 0)
		{
			possible_periods.push_back(i);
		}
	}
	int query_cnt; cin >> query_cnt;
	vector<int> elements(n);
	for (int i = 0; i < n; i++)
	{
		cin >> elements[i];
		//elements[i] = rand() % 30;
	}
	vector<int> xor_values(n);
	for (int i = 0; i < n; i++)
	{
		xor_values[i] = elements[i] ^ elements[(i + 1) % n];
	}

	vector<int> cnt_correct(possible_periods.size());
	for (int j = 0; j < possible_periods.size(); j++)
	{
		int period = possible_periods[j];
		for (int i = 0; i < n; i++)
		{
			if (xor_values[i] == xor_values[(i+period)%n])
			{
				cnt_correct[j]++;
			}
		}
	}

	for (int i = 0; i < possible_periods.size(); i++)
	{
		if (cnt_correct[i] == n)
		{
			cout << possible_periods[i] << "\n";
			break;
		}
	}

	for (int i = 0; i < query_cnt; i++)
	{
		int pos, new_val; 
		cin >> pos >> new_val;
		//pos = rand() % n + 1;
		//new_val = rand() % 30;
		//cout << pos << " " << new_val << "\n";
		pos--;

		for (int j = 0; j < possible_periods.size(); j++)
		{
			int period = possible_periods[j];
			int tmp_pos = pos;
			for (int k = 0; k < 2; k++)
			{
				if (xor_values[(pos + period) % n] == xor_values[pos])
					cnt_correct[j]--;
				if (xor_values[(pos - period + n) % n] == xor_values[pos])
					cnt_correct[j]--;
				pos = (pos - 1 + n) % n;
			}
			pos = tmp_pos;
		}

		elements[pos] = new_val;
		xor_values[pos] = elements[pos] ^ elements[(pos + 1) % n];
		xor_values[(pos - 1 + n) % n] = elements[pos] ^ elements[(pos - 1 + n) % n];
		for (int j = 0; j < possible_periods.size(); j++)
		{
			int period = possible_periods[j];
			int tmp_pos = pos;
			for (int k = 0; k < 2; k++)
			{
				if (xor_values[(pos + period) % n] == xor_values[pos])
					cnt_correct[j]++;
				if (xor_values[(pos - period + n) % n] == xor_values[pos])
					cnt_correct[j]++;
				pos = (pos - 1 + n) % n;
			}			
			pos = tmp_pos;
		}
		for (int i = 0; i < possible_periods.size(); i++)
		{
			/*auto brute = bruteforce(xor_values);
			for (int j = 0; j < brute.size(); j++)
			{
				if (cnt_correct[j] != brute[j])
				{
					cout << "wa\n";
				}
			}*/
			if (cnt_correct[i] == n)
			{
				int sol = possible_periods[i];
				
				cout << possible_periods[i] << "\n";
				break;
			}
		}
	}


	return 0;
}